IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[P_EST_PROD_CPL_ESTOQUE_ORCAMENTO]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[P_EST_PROD_CPL_ESTOQUE_ORCAMENTO]
GO


/*
=======================================================================================
'Nvel Classificao.: INFORMAO RESTRITA
'Verso..............: 20230222
'Job.................:  
'Nome................: [P_EST_PROD_CPL_ESTOQUE_ORCAMENTO]
'Objetivo............: Consulta estoque na App Oramento
'Tabelas.............: 
'Dt Modificao......: 12/02/2021
'Dt Ult Alteraco....: 22/02/2023
'Criado por..........: --
'Alterado por........: Jerfeson Barbosa
'Modificao.........: TAdicionou DROP TABLE das tbelas temporais
'=======================================================================================

=======================================================================================
'Job.................:  
'Funo..............: 
'Objetivo............: Consulta estoque na App Oramento 
'Tabelas.............: 
'Dt Modificao......: 22/02/2023
'Modificao.........: Tag #A001 Validar a flag ORC_TELE_MOSTRA_ESTOQUE_DEPOSITO
'=======================================================================================
Tag #A001 - Alterao do codigo  
Tag #I001 - Incluso de novo codigo 
*/

--P_EST_PROD_CPL_ESTOQUE_ORCAMENTO 1,4,477797 
CREATE PROCEDURE [dbo].[P_EST_PROD_CPL_ESTOQUE_ORCAMENTO]
                 @CD_EMP    INT
               , @CD_FILIAL INT
               , @CD_PROD   INT
AS
     SET NOCOUNT ON;
	 DECLARE @CD_BANDEIRA INT;
	 DECLARE @FLAGMOSTRAESTOQUE 		 	VARCHAR;
	 DECLARE @FLAGNAOSEPARARREGIAOFISCAL 	VARCHAR;
	 DECLARE @FLAG_MOSTRA_ESTOQUE_DEPOSITO 	INT;
     SET @FLAGNAOSEPARARREGIAOFISCAL = '';
	CREATE TABLE #RSRETORNO(
								CD_FILIAL   INT 
							, FILIAL_NOME VARCHAR(100)
							, FILIAL_END  VARCHAR(150)
							, ESTOQUE     VARCHAR(100)
							, PENDENTE    INT);
	SET @FLAGMOSTRAESTOQUE			  = ISNULL((SELECT ISNULL(VALOR, '') FROM PRC_EMP_CONFIG WHERE CD_EMP=1 AND CD_CHAVE = 'FLAG_MOSTRA_ESTOQUE_FILIAL'), '');
	SET @FLAGNAOSEPARARREGIAOFISCAL   = ISNULL((SELECT ISNULL(VALOR, '') FROM PRC_EMP_CONFIG WHERE CD_EMP=1 AND CD_CHAVE = 'FLAG_NAO_SEPARAR_REGIAO_FISCAL'), '');
	SET @FLAG_MOSTRA_ESTOQUE_DEPOSITO = ISNULL((SELECT ISNULL(VALOR, 0) FROM PRC_EMP_CONFIG WHERE CD_CHAVE = 'ORC_TELE_MOSTRA_ESTOQUE_DEPOSITO'), 0);
	IF @FLAGMOSTRAESTOQUE = ''
    BEGIN
		SET @FLAGMOSTRAESTOQUE = '0';
    END;
    IF @FLAGNAOSEPARARREGIAOFISCAL = ''
    BEGIN
		SET @FLAGNAOSEPARARREGIAOFISCAL = '0';
    END;
	CREATE TABLE #REGIAOFISCAL(CD_EMP    INT, CD_FILIAL INT);
    IF @FLAGNAOSEPARARREGIAOFISCAL = '0'
	BEGIN
		INSERT INTO #REGIAOFISCAL
		SELECT
			CD_EMP
			, CD_FILIAL
		FROM
			PRC_REGIAO_FISCAL_PRC_FILIAL
		WHERE 
			CD_EMP = @CD_EMP
			AND CD_REGIAO_FISCAL =(SELECT CD_REGIAO_FISCAL FROM PRC_REGIAO_FISCAL_PRC_FILIAL WHERE CD_EMP = @CD_EMP AND CD_FILIAL = @CD_FILIAL);
	END;
	IF @FLAGNAOSEPARARREGIAOFISCAL = '1'
	BEGIN
		INSERT INTO #REGIAOFISCAL
		SELECT
			CD_EMP
			, CD_FILIAL
		FROM
			PRC_REGIAO_FISCAL_PRC_FILIAL;
	END; 
	SET @CD_BANDEIRA = ISNULL((SELECT TOP 1 CD_BANDEIRA FROM PRC_BANDEIRA_PRC_FILIAL
								WHERE CD_EMP=@CD_EMP AND CD_FILIAL = @CD_FILIAL),0)
	IF @CD_BANDEIRA > 0 
	BEGIN
		TRUNCATE TABLE #REGIAOFISCAL;
		INSERT INTO #REGIAOFISCAL
		SELECT
			   CD_EMP
			 , CD_FILIAL
		FROM
			 PRC_BANDEIRA_PRC_FILIAL
		WHERE CD_EMP = @CD_EMP
			  AND CD_BANDEIRA = @CD_BANDEIRA;
	END
	INSERT INTO #RSRETORNO
	SELECT
		VEPCP.CD_FILIAL 
		, FL.NM_FANT
		, END_FILILAL+', '+BAIRRO
		, CAST((VEPCP.QT_EST - VEPCP.QT_PEND_SAI) AS VARCHAR)
		, VEPCP.QT_PEND_ENT
	FROM
		V_EST_PROD_CPL_PENDENCIAS AS VEPCP
		INNER JOIN #REGIAOFISCAL rf ON VEPCP.CD_EMP = rf.CD_EMP
		AND VEPCP.CD_FILIAL = rf.CD_FILIAL
		INNER JOIN PRC_FILIAL FL ON VEPCP.CD_EMP = FL.CD_EMP
		AND VEPCP.CD_FILIAL = FL.CD_FILIAL
	WHERE 
		VEPCP.CD_EMP = @CD_EMP
		AND (VEPCP.QT_EST > 0 OR VEPCP.QT_PEND_ENT > 0)
		AND VEPCP.CD_PROD = @CD_PROD;
-- Tag #I001 No mostrar o estoque da filial Deposito. 
	IF @FLAG_MOSTRA_ESTOQUE_DEPOSITO = 0
	BEGIN
		DELETE D
		  FROM #RSRETORNO D
				JOIN PRC_FILIAL_DEPOSITO DEP ON D.CD_FILIAL = DEP.CD_FILIAL
			    JOIN PRC_FILIAL_DEPOSITO_PRC_FILIAL FILIAL ON FILIAL.CD_CTR_DEPO = DEP.CD_CTR_DEPO 
														  AND FILIAL.CD_EMP	     = DEP.CD_EMP
          WHERE FILIAL.CD_FILIAL = @CD_FILIAL;
    END;
     IF @FLAGMOSTRAESTOQUE = '0'
         BEGIN
             UPDATE #RSRETORNO
               SET
                   ESTOQUE = 'Disponivel'
             WHERE
                   CD_FILIAL <> @CD_FILIAL;
         END;
	 SELECT
            RIGHT('0000'+ CAST(CD_FILIAL AS VARCHAR), 4)  AS 'Filial'
          , FILIAL_NOME
          , FILIAL_END
          , ESTOQUE AS 'Estoque'
          , PENDENTE AS 'Pendente'
     FROM
          #RSRETORNO
     ORDER BY FILIAL;

--Drop das tabelas temporarias
DROP TABLE #RSRETORNO
DROP TABLE #REGIAOFISCAL

GO


